# Inconsistency‑Aware Minimization (IAM) — Supplementary Material

This repository accompanies our ICLR 2026 submission **“Inconsistency‑Aware Minimization: Improving Generalization with Unlabeled Data.”** 

---

## 1  Quick‑start (TL;DR)

```bash
# create & activate isolated environment
conda create -n iam python=3.10 -y
conda activate iam

# install dependencies
pip install -r requirements.txt

# run CIFAR‑10 experiment (IAM‑D)
python3 train.py --optimizer IAM --beta 1.0 --rho 0.1 --semi False

# run CIFAR-10 experimnet (IAM-S)
python3 train2.py 
```

---

## 2  Repository layout

```
├── src/
│   ├── data.py      # data loaders & augmentation
│   ├── model.py     # WideResNet, 6CNN backbone
│   ├── SAM.py       # Sharpness‑Aware Minimization
│   ├── IAM.py       # IAM optimizers, loss, estimating local inconsistency
│   ├── train.py     # IAM-D training
|   ├── train2.py    # IAM-S training
│   |── simclr.py    # self‑supervised experiments
│   |── fixmatch.py  # semi-supervised experiments
│   └── toy.ipynb    # code for toy example in Appendix D
├── figures
│   ├── heatmap10.png   # heatmap for hyper parameter sensitivity in IAM-D
│   ├── heatmap100.png  # heatmap for hyper parameter sensitivity in IAM-D
│   ├── IAM-S_rho.png   # 
│   ├── K_vs_LI.png     # 
├── requirements.txt # Python deps (PyTorch ≥ 2.5.1)
├── LICENSE          # MIT License for our code
└── LICENSE.third_party  # licenses for external code (see below)
```

---

## 3  Reproducing results

| Paper section                    | Command (seed 0 example)                                                     |
| -------------------------------- | ---------------------------------------------------------------------------- |
| Supervised CIFAR‑10  (IAM‑D)     | `python3 train.py --dataset CIFAR-10 --optimizer IAM --beta 1.0 --rho 0.1`    |
| Supervised CIFAR‑100 (IAM‑D)     | `python3 train.py --dataset CIFAR-100 --optimizer IAM --beta 10.0 --rho 0.1`  |
| Supervised CIFAR‑10  (IAM‑S)     | `python3 train2.py --dataset CIFAR-10  --rho 0.1` |
| Supervised CIFAR‑100 (IAM‑S)     | `python3 train2.py --dataset CIFAR-100 --rho 0.5` |
| Semi-supervised CIFAR‑10 (IAM‑D) | `python3 train.py --optimizer IAM --beta 1.0 --rho 0.1 --semi True` |
| Self‑supervised SimCLR (IAM‑D)   | `python3 simclr.py` |
| toy example | run toy.ipynb|


## 4 Additional details and figures

### 4.1 role of $K$ in estimating local inconsistency S_ρ(θ)
<p align="center">
  <img src="./figures/K_vs_LI.png" alt="Loss landscape with and without SAM" width="512"/>  
</p>

<p align="center">
  <sub><em>Number of step K and estimated local inconsistency with algorithm 1 and Projected Gradient Ascent (PGA). </em></sub>
</p>

Algorithm 1 can approximate local inconsistency in a few step. And, in K > 1, algorithm 1 solve maximization problem in constraintion  $ \|\delta\| \le \rho$ better than PGA.

So $K=1$ can offer efficient approximation of local inconsistency, as mentioned in Appendix C. 
---

## 5  Third‑party code & licenses

| File(s)                                                 | Origin                                                                                                                                                                                     | License     |
| ------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------ | ----------- |
| `src/model.py`, `src/data.py` | Adapted from *Sharpness‑Aware Minimization* reference implementation by **Davide Borra** — [https://github.com/davda54/sam](https://github.com/davda54/sam) | MIT License |

All adapted sections retain the original MIT license header.  The full license text is provided in **`LICENSE.third_party`** as required by NeurIPS policy.

---
© 2025 Anonymous Author(s)  — released under the MIT License.
